/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.ui.paginas;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.RaizModelo;
import ec.gob.sri.dimm.api.ui.VistaModelo;
import ec.gob.sri.dimm.api.ui.editores.EditorBase;
import ec.gob.sri.dimm.api.ui.paginas.PaginaBase;
import ec.gob.sri.dimm.api.ui.util.controles.AyudanteViewer;
import ec.gob.sri.dimm.api.ui.util.eventos.AyudanteSelectionChangedEvent;
import ec.gob.sri.dimm.ats.modelo.obj.Comprobante;
import ec.gob.sri.dimm.ats.modelo.obj.DetalleAir;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.Sujeto;
import ec.gob.sri.dimm.ats.modelo.obj.rendimientos.ComprobanteRendimiento;
import ec.gob.sri.dimm.ats.modelo.obj.rendimientos.DetalleAirRendimiento;
import ec.gob.sri.dimm.ats.modelo.obj.rendimientos.Rendimiento;
import ec.gob.sri.dimm.ats.ui.ConstantesUI;
import ec.gob.sri.dimm.ats.ui.dialogos.DialogoComprobanteRendimiento;
import ec.gob.sri.dimm.ats.ui.dialogos.DialogoConceptoRetencion;
import ec.gob.sri.dimm.ats.ui.dialogos.DialogoRetenido;
import ec.gob.sri.dimm.ats.ui.dialogos.filtros.IdentificacionRendimientosFilter;
import ec.gob.sri.dimm.ats.ui.editores.EditorATS;
import java.util.ArrayList;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.ColumnLayout;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wb.swt.ResourceManager;
import swing2swt.layout.BorderLayout;

public class PaginaRendimientos
extends PaginaBase<EditorATS>
implements VistaModelo<Iva> {
    private DataBindingContext m_bindingContext;
    private Rendimiento rendimientoSeleccionado;
    private ComprobanteRendimiento comprobanteSeleccionado;
    private DetalleAirRendimiento detalleAirSeleccionado;
    private Iva modeloDatos;
    private Table tblRetenidos;
    private Table tblComprobantes;
    private Text txtIdentificacion;
    private Button btnBuscar;
    private ToolItem tltmNuevoRetenido;
    private TableViewer tvRetenidos;
    private ToolItem tltmEliminarRetenido;
    private ToolItem tltmEditarRetenido;
    private ToolItem tltmNuevoBeneficiario;
    private TableViewer tvComprobantes;
    private ToolItem tltmEliminarBeneficiario;
    private ToolItem tltmEditarBeneficiario;
    private Table tblConceptos;
    private ToolItem tltmNuevoConcepto;
    private ToolItem tltmEditarConcepto;
    private ToolItem tltmEliminarConcepto;
    private TableViewer tvConceptos;
    private IdentificacionRendimientosFilter filtroRendimientos;
    private Label lblRegistros;

    public PaginaRendimientos(EditorATS editor, String id, String title) {
        super((EditorBase)editor, id, title);
    }

    public void setModeloDatos(Iva modeloDatos) {
        this.modeloDatos = modeloDatos;
    }

    public void procesarModeloDatos() {
    }

    protected void createFormContent(IManagedForm managedForm) {
        managedForm.getForm().setDelayedReflow(true);
        FormToolkit toolkit = managedForm.getToolkit();
        ScrolledForm form = managedForm.getForm();
        Composite body = form.getBody();
        toolkit.paintBordersFor(body);
        managedForm.getForm().getBody().setLayout((Layout)new ColumnLayout());
        Section sctnRecaps = managedForm.getToolkit().createSection(managedForm.getForm().getBody(), 256);
        managedForm.getToolkit().paintBordersFor((Composite)sctnRecaps);
        sctnRecaps.setText("Rendimientos Financieros");
        Composite composite = managedForm.getToolkit().createComposite((Composite)sctnRecaps, 0);
        managedForm.getToolkit().paintBordersFor(composite);
        sctnRecaps.setClient((Control)composite);
        composite.setLayout((Layout)new FormLayout());
        ExpandableComposite xcRetenidos = managedForm.getToolkit().createExpandableComposite(composite, 256);
        FormData fd_xcRetenidos = new FormData();
        fd_xcRetenidos.bottom = new FormAttachment(0, 250);
        fd_xcRetenidos.top = new FormAttachment(0, 3);
        fd_xcRetenidos.left = new FormAttachment(0, 3);
        xcRetenidos.setLayoutData((Object)fd_xcRetenidos);
        managedForm.getToolkit().paintBordersFor((Composite)xcRetenidos);
        xcRetenidos.setText("Informaci\u00f3n de Retenidos");
        Composite cRecap = new Composite((Composite)xcRetenidos, 0);
        xcRetenidos.setClient((Control)cRecap);
        managedForm.getToolkit().adapt(cRecap);
        managedForm.getToolkit().paintBordersFor(cRecap);
        cRecap.setLayout((Layout)new BorderLayout(0, 0));
        Composite cCabecera = new Composite(cRecap, 0);
        cCabecera.setLayoutData((Object)"North");
        managedForm.getToolkit().adapt(cCabecera);
        managedForm.getToolkit().paintBordersFor(cCabecera);
        GridLayout gl_cCabecera = new GridLayout(19, false);
        gl_cCabecera.marginWidth = 0;
        cCabecera.setLayout((Layout)gl_cCabecera);
        ToolBar toolBar = new ToolBar(cCabecera, 0x820000);
        GridData gd_toolBar = new GridData(16384, 4, false, false, 16, 1);
        gd_toolBar.widthHint = 190;
        toolBar.setLayoutData((Object)gd_toolBar);
        managedForm.getToolkit().adapt((Composite)toolBar);
        managedForm.getToolkit().paintBordersFor((Composite)toolBar);
        this.tltmNuevoRetenido = new ToolItem(toolBar, 0);
        this.tltmNuevoRetenido.setText("Nuevo");
        this.tltmEditarRetenido = new ToolItem(toolBar, 0);
        this.tltmEditarRetenido.setText("Editar");
        this.tltmEliminarRetenido = new ToolItem(toolBar, 0);
        this.tltmEliminarRetenido.setText("Eliminar");
        Label lblNIdentificacin = new Label(cCabecera, 0);
        GridData gd_lblNIdentificacin = new GridData(131072, 0x1000000, false, false, 1, 1);
        gd_lblNIdentificacin.widthHint = 100;
        lblNIdentificacin.setLayoutData((Object)gd_lblNIdentificacin);
        managedForm.getToolkit().adapt((Control)lblNIdentificacin, true, true);
        lblNIdentificacin.setText("N\u00b0 Identificaci\u00f3n");
        this.txtIdentificacion = new Text(cCabecera, 2048);
        this.txtIdentificacion.setTextLimit(13);
        GridData gd_txtIdentificacion = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtIdentificacion.widthHint = 120;
        this.txtIdentificacion.setLayoutData((Object)gd_txtIdentificacion);
        managedForm.getToolkit().adapt((Control)this.txtIdentificacion, true, true);
        this.btnBuscar = new Button(cCabecera, 0);
        this.btnBuscar.setImage(ResourceManager.getPluginImage((String)"ec.gob.sri.dimm.ats.ui", (String)"iconos/search.png"));
        managedForm.getToolkit().adapt((Control)this.btnBuscar, true, true);
        this.tvRetenidos = new TableViewer(cRecap, 67584);
        this.filtroRendimientos = new IdentificacionRendimientosFilter();
        this.filtroRendimientos.setSearchText("");
        this.tvRetenidos.addFilter((ViewerFilter)this.filtroRendimientos);
        this.tvRetenidos.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent arg0) {
                PaginaRendimientos.this.rendimientoSeleccionado = (Rendimiento)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)arg0);
                PaginaRendimientos.this.detalleAirSeleccionado = null;
                PaginaRendimientos.this.comprobanteSeleccionado = null;
                AyudanteViewer.seleccionarElemento((Viewer)PaginaRendimientos.this.tvComprobantes, null);
            }
        });
        this.tblRetenidos = this.tvRetenidos.getTable();
        this.tblRetenidos.setLinesVisible(true);
        this.tblRetenidos.setHeaderVisible(true);
        managedForm.getToolkit().paintBordersFor((Composite)this.tblRetenidos);
        TableColumn tblclmnNIdRetenido = new TableColumn(this.tblRetenidos, 0);
        tblclmnNIdRetenido.setWidth(180);
        tblclmnNIdRetenido.setText("N\u00b0 identificaci\u00f3n Retenido");
        TableColumn tblclmnTipoIdRetenido = new TableColumn(this.tblRetenidos, 0);
        tblclmnTipoIdRetenido.setWidth(260);
        tblclmnTipoIdRetenido.setText("Tipo Identificaci\u00f3n del Retenido");
        Composite cRegistros = new Composite(cRecap, 0);
        cRegistros.setLayoutData((Object)"South");
        managedForm.getToolkit().adapt(cRegistros);
        managedForm.getToolkit().paintBordersFor(cRegistros);
        cRegistros.setLayout((Layout)new GridLayout(1, false));
        this.lblRegistros = new Label(cRegistros, 0);
        GridData gd_lblRegistros = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblRegistros.widthHint = 452;
        this.lblRegistros.setLayoutData((Object)gd_lblRegistros);
        managedForm.getToolkit().adapt((Control)this.lblRegistros, true, true);
        ExpandableComposite xcAir = managedForm.getToolkit().createExpandableComposite(composite, 512);
        FormData fd_xcComprobantes = new FormData();
        fd_xcComprobantes.top = new FormAttachment((Control)xcRetenidos, 10);
        fd_xcComprobantes.bottom = new FormAttachment(0, 500);
        fd_xcComprobantes.left = new FormAttachment(0, 3);
        xcAir.setLayoutData((Object)fd_xcComprobantes);
        managedForm.getToolkit().paintBordersFor((Composite)xcAir);
        xcAir.setText("Comprobantes de Retenci\u00f3n");
        Composite composite_1 = managedForm.getToolkit().createComposite((Composite)xcAir, 0);
        managedForm.getToolkit().paintBordersFor(composite_1);
        xcAir.setClient((Control)composite_1);
        composite_1.setLayout((Layout)new BorderLayout(0, 0));
        Composite cCabeceraAir = managedForm.getToolkit().createComposite(composite_1, 0);
        cCabeceraAir.setLayoutData((Object)"North");
        managedForm.getToolkit().paintBordersFor(cCabeceraAir);
        ToolBar toolBar_1 = new ToolBar(cCabeceraAir, 0x820000);
        toolBar_1.setBounds(0, 0, 295, 30);
        managedForm.getToolkit().adapt((Composite)toolBar_1);
        managedForm.getToolkit().paintBordersFor((Composite)toolBar_1);
        this.tltmNuevoBeneficiario = new ToolItem(toolBar_1, 0);
        this.tltmNuevoBeneficiario.setText("Nuevo");
        this.tltmEditarBeneficiario = new ToolItem(toolBar_1, 0);
        this.tltmEditarBeneficiario.setText("Editar");
        this.tltmEliminarBeneficiario = new ToolItem(toolBar_1, 0);
        this.tltmEliminarBeneficiario.setText("Eliminar");
        this.tvComprobantes = new TableViewer(composite_1, 67584);
        this.tvComprobantes.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent arg0) {
                PaginaRendimientos.this.comprobanteSeleccionado = (ComprobanteRendimiento)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)arg0);
                PaginaRendimientos.this.detalleAirSeleccionado = null;
            }
        });
        this.tblComprobantes = this.tvComprobantes.getTable();
        this.tblComprobantes.setLinesVisible(true);
        this.tblComprobantes.setHeaderVisible(true);
        managedForm.getToolkit().paintBordersFor((Composite)this.tblComprobantes);
        TableColumn tblclmnNumSerie = new TableColumn(this.tblComprobantes, 0);
        tblclmnNumSerie.setWidth(120);
        tblclmnNumSerie.setText("Serie-Secuencial");
        TableColumn tblclmnNumAutorizacion = new TableColumn(this.tblComprobantes, 0);
        tblclmnNumAutorizacion.setWidth(150);
        tblclmnNumAutorizacion.setText("N\u00b0 Autorizaci\u00f3n");
        ExpandableComposite xpndblcmpstNewExpandablecomposite = managedForm.getToolkit().createExpandableComposite(composite, 256);
        FormData fd_xpndblcmpstNewExpandablecomposite = new FormData();
        fd_xpndblcmpstNewExpandablecomposite.top = new FormAttachment((Control)xcRetenidos, 10);
        fd_xpndblcmpstNewExpandablecomposite.left = new FormAttachment(0, 325);
        fd_xpndblcmpstNewExpandablecomposite.bottom = new FormAttachment(0, 500);
        xpndblcmpstNewExpandablecomposite.setLayoutData((Object)fd_xpndblcmpstNewExpandablecomposite);
        managedForm.getToolkit().paintBordersFor((Composite)xpndblcmpstNewExpandablecomposite);
        xpndblcmpstNewExpandablecomposite.setText("Conceptos de Retenci\u00f3n");
        Composite composite_2 = new Composite((Composite)xpndblcmpstNewExpandablecomposite, 0);
        managedForm.getToolkit().adapt(composite_2);
        managedForm.getToolkit().paintBordersFor(composite_2);
        xpndblcmpstNewExpandablecomposite.setClient((Control)composite_2);
        composite_2.setLayout((Layout)new BorderLayout(0, 0));
        Composite cpBarra = new Composite(composite_2, 0);
        cpBarra.setLayoutData((Object)"North");
        managedForm.getToolkit().adapt(cpBarra);
        managedForm.getToolkit().paintBordersFor(cpBarra);
        GridLayout gl_cpBarra = new GridLayout(1, false);
        gl_cpBarra.marginHeight = 0;
        gl_cpBarra.verticalSpacing = 0;
        gl_cpBarra.marginWidth = 0;
        gl_cpBarra.horizontalSpacing = 0;
        cpBarra.setLayout((Layout)gl_cpBarra);
        ToolBar toolBar_2 = new ToolBar(cpBarra, 0x820000);
        managedForm.getToolkit().adapt((Composite)toolBar_2);
        managedForm.getToolkit().paintBordersFor((Composite)toolBar_2);
        this.tltmNuevoConcepto = new ToolItem(toolBar_2, 0);
        this.tltmNuevoConcepto.setText("Nuevo");
        this.tltmEditarConcepto = new ToolItem(toolBar_2, 0);
        this.tltmEditarConcepto.setText("Editar");
        this.tltmEliminarConcepto = new ToolItem(toolBar_2, 0);
        this.tltmEliminarConcepto.setText("Eliminar");
        this.tvConceptos = new TableViewer(composite_2, 67584);
        this.tvConceptos.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent arg0) {
                PaginaRendimientos.this.detalleAirSeleccionado = (DetalleAirRendimiento)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)arg0);
            }
        });
        this.tblConceptos = this.tvConceptos.getTable();
        this.tblConceptos.setLinesVisible(true);
        this.tblConceptos.setHeaderVisible(true);
        this.tblConceptos.setLayoutData((Object)"Center");
        managedForm.getToolkit().paintBordersFor((Composite)this.tblConceptos);
        TableColumn tblclmnConcepto = new TableColumn(this.tblConceptos, 0);
        tblclmnConcepto.setWidth(100);
        tblclmnConcepto.setText("Concepto");
        TableColumn tblclmnBaseImponible = new TableColumn(this.tblConceptos, 0);
        tblclmnBaseImponible.setWidth(100);
        tblclmnBaseImponible.setText("Base Imponible");
        TableColumn tblclmnValorRetenido = new TableColumn(this.tblConceptos, 0);
        tblclmnValorRetenido.setWidth(100);
        tblclmnValorRetenido.setText("Valor Retenido");
        this.initDataBindings();
        this.bntNuevoRendimientoClicked();
        this.btnEditarRendimientoClicked();
        this.btnEliminarRendimientoClicked();
        this.btnNuevoComprobanteClicked();
        this.btnEditarComprobanteClicked();
        this.btnEliminarComprobanteClicked();
        this.btnNuevoConceptoClicked();
        this.btnEditarConceptoClicked();
        this.btnEliminarConceptoClicked();
        this.btnBuscarClicked();
    }

    private void generarAlertaFiltro(String textoFiltro) {
        if (StringUtil.isNullOrEmpty((String)textoFiltro)) {
            this.lblRegistros.setForeground(ConstantesUI.COLOR_FOREGROUND);
            this.lblRegistros.setText(String.format("Total Registros: %d %s", this.modeloDatos.getRendimientos().size(), "Rendimiento(s)"));
        } else {
            this.lblRegistros.setForeground(ConstantesUI.COLOR_FILTRO);
            this.lblRegistros.setText(String.format("N\u00famero de registros filtrados: %d, de un total de %d %s", this.tvRetenidos.getTable().getItemCount(), this.modeloDatos.getRendimientos().size(), "Rendimiento(s)"));
        }
    }

    private void bntNuevoRendimientoClicked() {
        this.tltmNuevoRetenido.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Rendimiento rendimiento = new Rendimiento();
                rendimiento.setPropietario((ObjetoModelo)PaginaRendimientos.this.modeloDatos);
                if (PaginaRendimientos.this.abrirDialogoRetenido(rendimiento, false)) {
                    PaginaRendimientos.this.modeloDatos.agregarRendimiento(rendimiento);
                    ((EditorATS)PaginaRendimientos.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaRendimientos.this.modeloDatos);
                    PaginaRendimientos.this.generarAlertaFiltro(PaginaRendimientos.this.txtIdentificacion.getText());
                }
            }
        });
    }

    private void btnBuscarClicked() {
        this.btnBuscar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PaginaRendimientos.this.filtroRendimientos.setSearchText(PaginaRendimientos.this.txtIdentificacion.getText());
                PaginaRendimientos.this.tvRetenidos.refresh();
                PaginaRendimientos.this.generarAlertaFiltro(PaginaRendimientos.this.txtIdentificacion.getText());
            }
        });
    }

    private void btnEditarRendimientoClicked() {
        this.tltmEditarRetenido.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PaginaRendimientos.this.rendimientoSeleccionado != null) {
                    Rendimiento copiaEdicion = PaginaRendimientos.this.rendimientoSeleccionado.crearCopiaEdicion();
                    if (PaginaRendimientos.this.abrirDialogoRetenido(copiaEdicion, true)) {
                        PaginaRendimientos.this.rendimientoSeleccionado.actualizarInformacion(copiaEdicion);
                        PaginaRendimientos.this.tvRetenidos.refresh();
                        ((EditorATS)PaginaRendimientos.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaRendimientos.this.modeloDatos);
                    }
                } else {
                    PaginaRendimientos.this.mostrarAdvertencia("No ha seleccionado un sujeto Retenido para editar");
                }
            }
        });
    }

    private void btnEliminarRendimientoClicked() {
        this.tltmEliminarRetenido.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PaginaRendimientos.this.rendimientoSeleccionado != null && PaginaRendimientos.this.mostrarConfirmacion("\u00bfEst\u00e1 seguro de que desea eliminar el registro seleccionado?") && PaginaRendimientos.this.modeloDatos.eliminarRendimiento(PaginaRendimientos.this.rendimientoSeleccionado)) {
                    PaginaRendimientos.this.rendimientoSeleccionado = null;
                    ((EditorATS)PaginaRendimientos.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaRendimientos.this.modeloDatos);
                    PaginaRendimientos.this.generarAlertaFiltro(PaginaRendimientos.this.txtIdentificacion.getText());
                }
            }
        });
    }

    private void btnNuevoComprobanteClicked() {
        this.tltmNuevoBeneficiario.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PaginaRendimientos.this.rendimientoSeleccionado != null) {
                    ComprobanteRendimiento comprobante = new ComprobanteRendimiento();
                    comprobante.setPropietario((ObjetoModelo)PaginaRendimientos.this.rendimientoSeleccionado);
                    comprobante.setObligatorio(true);
                    comprobante.inicializar();
                    if (PaginaRendimientos.this.abrirDialogoComprobante(comprobante, false)) {
                        PaginaRendimientos.this.rendimientoSeleccionado.agregarComprobantesRetencion(comprobante);
                        PaginaRendimientos.this.tvComprobantes.refresh();
                        ((EditorATS)PaginaRendimientos.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaRendimientos.this.modeloDatos);
                    }
                } else {
                    PaginaRendimientos.this.mostrarAdvertencia("No ha seleccionado un Retenido");
                }
            }
        });
    }

    private void btnNuevoConceptoClicked() {
        this.tltmNuevoConcepto.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PaginaRendimientos.this.comprobanteSeleccionado != null) {
                    DetalleAirRendimiento detalleAir = new DetalleAirRendimiento();
                    detalleAir.setPropietario((ObjetoModelo)PaginaRendimientos.this.comprobanteSeleccionado);
                    if (PaginaRendimientos.this.abrirDialogoConcepto(detalleAir, false)) {
                        PaginaRendimientos.this.comprobanteSeleccionado.agregarDetallesAirRendimientos(detalleAir);
                        PaginaRendimientos.this.tvConceptos.refresh();
                        ((EditorATS)PaginaRendimientos.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaRendimientos.this.modeloDatos);
                    }
                } else {
                    PaginaRendimientos.this.mostrarAdvertencia("No ha seleccionado un Comprobante de Retenci\u00f3n");
                }
            }
        });
    }

    private void btnEditarConceptoClicked() {
        this.tltmEditarConcepto.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PaginaRendimientos.this.detalleAirSeleccionado != null) {
                    DetalleAirRendimiento copiaEdicion = PaginaRendimientos.this.detalleAirSeleccionado.crearCopiaEdicion();
                    if (PaginaRendimientos.this.abrirDialogoConcepto(copiaEdicion, true)) {
                        PaginaRendimientos.this.detalleAirSeleccionado.actualizarInformacion((DetalleAir)copiaEdicion);
                        PaginaRendimientos.this.tvConceptos.refresh();
                        ((EditorATS)PaginaRendimientos.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaRendimientos.this.modeloDatos);
                    }
                } else {
                    PaginaRendimientos.this.mostrarAdvertencia("No ha seleccionado un Concepto de Retenci\u00f3n");
                }
            }
        });
    }

    private void btnEliminarConceptoClicked() {
        this.tltmEliminarConcepto.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PaginaRendimientos.this.detalleAirSeleccionado != null && PaginaRendimientos.this.mostrarConfirmacion("\u00bfEst\u00e1 seguro de que desea eliminar el registro seleccionado?") && PaginaRendimientos.this.comprobanteSeleccionado.eliminarDetallesAirRendimientos(PaginaRendimientos.this.detalleAirSeleccionado)) {
                    PaginaRendimientos.this.detalleAirSeleccionado = null;
                    ((EditorATS)PaginaRendimientos.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaRendimientos.this.modeloDatos);
                }
            }
        });
    }

    private boolean abrirDialogoComprobante(ComprobanteRendimiento modeloDatos, boolean editando) {
        DialogoComprobanteRendimiento dialogo = new DialogoComprobanteRendimiento(this.getSite(), this.rendimientoSeleccionado.getComprobantesRetencion(), editando, this.modeloDatos.periodo);
        dialogo.setModeloDatos(modeloDatos);
        dialogo.inicializarModeloValores();
        return dialogo.open() == 0;
    }

    private void btnEditarComprobanteClicked() {
        this.tltmEditarBeneficiario.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PaginaRendimientos.this.comprobanteSeleccionado != null) {
                    ComprobanteRendimiento copiaEdicion = PaginaRendimientos.this.comprobanteSeleccionado.crearCopiaEdicion();
                    copiaEdicion.setObligatorio(true);
                    copiaEdicion.setPropietario(PaginaRendimientos.this.comprobanteSeleccionado.getPropietario());
                    if (PaginaRendimientos.this.abrirDialogoComprobante(copiaEdicion, true)) {
                        PaginaRendimientos.this.comprobanteSeleccionado.actualizarInformacion((Comprobante)copiaEdicion);
                        PaginaRendimientos.this.tvComprobantes.refresh();
                        ((EditorATS)PaginaRendimientos.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaRendimientos.this.modeloDatos);
                    }
                } else {
                    PaginaRendimientos.this.mostrarAdvertencia("No ha seleccionado un Comprobante de Retenci\u00f3n");
                }
            }
        });
    }

    private void btnEliminarComprobanteClicked() {
        this.tltmEliminarBeneficiario.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PaginaRendimientos.this.comprobanteSeleccionado != null && PaginaRendimientos.this.mostrarConfirmacion("\u00bfEst\u00e1 seguro de que desea eliminar el registro seleccionado?") && PaginaRendimientos.this.rendimientoSeleccionado.eliminarComprobantesRentecion(PaginaRendimientos.this.comprobanteSeleccionado)) {
                    PaginaRendimientos.this.comprobanteSeleccionado = null;
                    ((EditorATS)PaginaRendimientos.this.getEditor()).obtenerAdministradorPersistencia().serializarObjeto((RaizModelo)PaginaRendimientos.this.modeloDatos);
                }
            }
        });
    }

    private boolean abrirDialogoRetenido(Rendimiento modeloDatos, boolean editando) {
        ArrayList<Sujeto> sujetosExistentes = new ArrayList<Sujeto>();
        Iva modeloPadre = (Iva)modeloDatos.getPropietario();
        for (Rendimiento rend : modeloPadre.getRendimientos()) {
            sujetosExistentes.add((Sujeto)rend.getRetenido());
        }
        DialogoRetenido dialogo = new DialogoRetenido(this.getSite(), sujetosExistentes, editando, this.modeloDatos.periodo);
        dialogo.setModeloDatos(modeloDatos);
        dialogo.inicializarModeloValores();
        return dialogo.open() == 0;
    }

    private boolean abrirDialogoConcepto(DetalleAirRendimiento modeloDatos, boolean editando) {
        if (this.comprobanteSeleccionado != null) {
            ArrayList<String> conceptosExistentes = new ArrayList<String>();
            for (DetalleAirRendimiento air : this.comprobanteSeleccionado.getDetallesAirRendimientos()) {
                conceptosExistentes.add(air.getConceptoRetencion());
            }
            DialogoConceptoRetencion dialogo = new DialogoConceptoRetencion(this.getSite(), editando, conceptosExistentes, this.modeloDatos.periodo, this.modeloDatos.getDatosDeclaracion().getMicro());
            dialogo.setModeloDatos(modeloDatos);
            dialogo.inicializarModeloValores();
            return dialogo.open() == 0;
        }
        this.mostrarAdvertencia("No ha seleccionado un Comprobante de Retenci\u00f3n");
        return false;
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ObservableListContentProvider listContentProvider = new ObservableListContentProvider();
        IObservableMap[] observeMaps = BeansObservables.observeMaps((IObservableSet)listContentProvider.getKnownElements(), Rendimiento.class, (String[])new String[]{"retenido.identificacion", "retenido.descripcionTipoIdentificacion"});
        this.tvRetenidos.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMaps));
        this.tvRetenidos.setContentProvider((IContentProvider)listContentProvider);
        IObservableList modeloDatosRendimientosObserveList = BeanProperties.list((String)"rendimientos").observe((Object)this.modeloDatos);
        this.tvRetenidos.setInput((Object)modeloDatosRendimientosObserveList);
        ObservableListContentProvider listContentProvider_1 = new ObservableListContentProvider();
        IObservableMap[] observeMaps_1 = BeansObservables.observeMaps((IObservableSet)listContentProvider_1.getKnownElements(), ComprobanteRendimiento.class, (String[])new String[]{"serial", "numAutorizacion"});
        this.tvComprobantes.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMaps_1));
        this.tvComprobantes.setContentProvider((IContentProvider)listContentProvider_1);
        IViewerObservableValue tvRetenidosObserveSingleSelection = ViewersObservables.observeSingleSelection((Viewer)this.tvRetenidos);
        IObservableList tvRetenidosComprobantesRetencionObserveDetailList = BeansObservables.observeDetailList((IObservableValue)tvRetenidosObserveSingleSelection, (String)"comprobantesRetencion", ComprobanteRendimiento.class);
        this.tvComprobantes.setInput((Object)tvRetenidosComprobantesRetencionObserveDetailList);
        ObservableListContentProvider listContentProvider_2 = new ObservableListContentProvider();
        IObservableMap[] observeMaps_2 = BeansObservables.observeMaps((IObservableSet)listContentProvider_2.getKnownElements(), DetalleAirRendimiento.class, (String[])new String[]{"descripcionConcepto", "baseImponibleRenta", "valorRetenido"});
        this.tvConceptos.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMaps_2));
        this.tvConceptos.setContentProvider((IContentProvider)listContentProvider_2);
        IViewerObservableValue tvComprobantesObserveSingleSelection = ViewersObservables.observeSingleSelection((Viewer)this.tvComprobantes);
        IObservableList tvComprobantesDetallesAirRendimientosObserveDetailList = BeansObservables.observeDetailList((IObservableValue)tvComprobantesObserveSingleSelection, (String)"detallesAirRendimientos", DetalleAirRendimiento.class);
        this.tvConceptos.setInput((Object)tvComprobantesDetallesAirRendimientosObserveDetailList);
        this.generarAlertaFiltro(this.txtIdentificacion.getText());
        return bindingContext;
    }
}

